/*****************************************************************************
*
* Copyright 2019 NXP
* All Rights Reserved
*
*****************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************/

#ifndef APUROIICP0PROCESSCONTROLLER_HPP
#define APUROIICP0PROCESSCONTROLLER_HPP

#include "roiicp_graph_names.h"
#include <umat.hpp>

#ifdef APEX2_EMULATE
#include "roiicp_process_type.h"
#else
#include str_header(ROIICP_PI,hpp)
#include <icp_data.h>
#include <apex.h>
using namespace icp;
#endif

namespace apugen {

class APU_RoiIcp0_Process_Controller {
private:
	ROIICP_PI * pProc;
public:
	APU_RoiIcp0_Process_Controller(int32_t apex_id = 0);
	~APU_RoiIcp0_Process_Controller();
	int32_t Init();
	int32_t Connect(vsdk::UMat& dataInput0, cv::Rect& rectRoi_Input0, vsdk::UMat& dataOutput0, cv::Rect& rectRoi_Output0);
	int32_t Start();
	int32_t Wait();
};
}

#endif /* APUROIICP0PROCESSCONTROLLER_HPP */

